#!/bin/bash
#make variables file

#Find all read1 and read2 fastq files in project directory and save to file
find $PWD -name \*1.fq.gz | sort > fastqFilesR1
find $PWD -name \*2.fq.gz | sort > fastqFilesR2

#Extract sampleID from the fastq file name
awk '{split($0,path,"/"); split(path[7],fileInfo,"_"); print fileInfo[1]"_"fileInfo[2],fileInfo[1],fileInfo[1]"_"fileInfo[2]"_"fileInfo[3]}' fastqFilesR1 > fastqInfo

#Paste R1, R2 and sampleInfo files side by side
paste fastqFilesR1 fastqFilesR2 fastqInfo > sampleInfo

#change into sample directory
cat sampleInfo | while read read1 read2 sampleID parentsample nothing;
do
cd /scratch/cmp1g20/RMS_resistance_data/LUCILES_DATA/rawdata/"$sampleID"
#make sample variable file
cat <<EOF >variables
read1="$read1"	read2="$read2"	sampleID="$sampleID"
EOF
done





